% sensing_mtx_trans.m
%   operator that represents the transpose of the sensing matrix with
%   respect to the block scrambled Hadamard measurement matrix
%
% Input:
%   y: the measurements
%   H: the Hadamard matrix
%   W: the sparsifying basis operator, e.g., dct or dwt
%   m: number of rows in the 2D-reshaped matrix of y
%   n: number of columns in the 2D-reshaped matrix of y
%   block_length: block length of the block scrambled Hadamard measurement
%   matrix
%   perm_x_ind: scramble index
%   msr_ind: measurements index
%   K: number of measurements
% Output:
%   theta: sparse coefficients
%   
% Written: Hao Fang
% Created: Apr. 2013

function theta = sensing_mtx_trans(y, H, W, m, n, block_length, perm_x_ind, msr_ind, K)
    y_2D = zeros(block_length, m*n/block_length);
    y_2D(msr_ind(1:K)) = y;
    x_p_2D = conj(H) * y_2D;
%     x_p_2D = x_p_2D ./ block_length; % normalized: H*H'./ block_length = I
    x_p = reshape(x_p_2D, m, n);
    x = zeros(m, n);
    x(perm_x_ind) = x_p;
    theta = reshape(W(x), m*n, 1);
end